<?php
/****************************************
 * XKLog 登录与注册页
 *
 * 此文件控制输出登录与注册页
 *
 * 更新：2009-06-10
 * 版本：V1.0
 ****************************************/
 
require('./include/loader.php');
@header("content-Type: text/html; charset=utf-8");

$action = getGP('do','G');

// 加载用户自定义函数
$fun_file = XKLOG_ROOT . './style/' . $_CACHE['set'][0]['Style'] . '/function.php';
if ( file_exists( $fun_file ) ) {
	include_once( $fun_file );
}
unset( $fun_file );

switch( $action )
{
    case 'login':
    	if( user_is_login() ) {
			show_message( '您已经登录，请勿重复登录' ,get_http_referer() );
			exit;
		}
        check_login();
    	break;
    case 'logout':
        logout();
    	break;
    case 'do_register':
    	if( user_is_login() ) {
			show_message( '您已经注册，请勿重复注册' ,get_http_referer() );
			exit;
		}
        user_register();
    	break;
       case 'register':
    	if( user_is_login() ) {
			show_message( '您已经注册，请勿重复注册' ,get_http_referer() );
			exit;
		}
       	$_ENV['title'] = "用户注册";
		template('register');
    	break;
    default:
    	if( user_is_login() ) {
			show_message( '您已经登录，请勿重复登录' ,get_http_referer() );
			exit;
		}
       	$_ENV['title'] = "用户登录";
		template('login');
}

function check_login() {
	$errmsg = array();
	$username = trim( getGP('username','P') );
	$password = getGP('password','P');
	$vdcode = getGP('vdcode','P');
	$remember = getGP('remember','P');

	if ( strlen($username) < 3 || strlen($username) > 20 ) {
		$errmsg[] = '用户名长度必须在3-20字节之间。';
	} elseif ( !check_username($username) ) {
		$errmsg[] = '用户名中含有非法字符或系统禁用关键字。';
	}
	if ( strlen($password) < 5 ){
		$errmsg[] = '密码长度不能小于5个字节。';
	}
	session_start();
	if ( strtolower($vdcode) != $_SESSION['vdcode'] ){
		$errmsg[] = '验证码不正确。';
	}
	unset($_SESSION['vdcode']);
	if (count($errmsg)){
		show_message( $errmsg, BLOG_PATH . 'login.php' );
		exit;
	}
	$flag = user_login($username, $password, ($remember?1:0));
	if ( $flag == 1) {
		show_message('登录成功，接下来将以会员身份登录。', BLOG_PATH . 'index.php');
	} elseif ( $flag == -1 ) {
		show_message('登录失败，您输入的用户名不存在。', BLOG_PATH . 'login.php');
	} else {
		show_message('登录失败，您输入的密码错误。', BLOG_PATH . 'login.php');
	}
}

function user_register() {
	global $db,$_CACHE;
	if ( $_CACHE['set'][0]['RegEnable'] == 0 ) {
		show_message( '对不起，本站已关闭新用户注册！', get_http_referer() );
		exit;
	}
	$user_name = trim( getGP('UserName','P') );
	$pass_word = getGP('PassWord','P');
	$pass_word_check = getGP('PassWord2','P');
	$email = getGP('Email','P');
	$qq = getGP('QQ','P');
	$index = getGP('Index','P');
	$vdcode = strtolower(getGP('vdcode','P'));
	$errmsg = array();
	session_start();
	if ( !isset( $_SESSION['vdcode'] ) ){
		$errmsg[] = '验证码不正确。';
	}elseif( $vdcode != $_SESSION['vdcode'] ){
		$errmsg[] = '验证码不正确。';
	}
	unset( $_SESSION['vdcode'] );
	if ( strlen( $user_name ) < 3 || strlen( $user_name ) > 20 ) {
		$errmsg[] = '用户名长度必须在3-20字节之间。';
	} elseif ( !check_username( $user_name ) ) {
		$errmsg[] = '用户名中含有非法字符或系统禁用关键字。';
	} elseif ( $db->result( "SELECT COUNT(UID) FROM `" . PREFIX_STR . "User` WHERE UserName = '" . $user_name . "'" ) ) {
		// 即使用户已经移入回收站，在彻底删除之前亦不能注册
		$errmsg[] = '该用户名已被注册。';
	}
	if ( strlen( $pass_word ) < 5 ) {
		$errmsg[] = '密码长度不能少于5个字节。';
	}
	if ( $pass_word != $pass_word_check ) {
		$errmsg[] = '两次输入的密码不一致。';
	}
	if ( empty( $email ) ) {
		//$errmsg[] = '请输入你的邮箱地址。';
	} elseif ( !check_email( $email ) ) {
		$errmsg[] = '你输入的邮箱地址格式有误。';
	} elseif ( $db->result( "SELECT COUNT(UID) FROM `" . PREFIX_STR . "User` WHERE Email = '" . $email . "'" ) ) {
		$errmsg[] = '您输入的邮箱地址已被注册。';
	}
	if ( count( $errmsg ) ){
		show_message( $errmsg, get_http_referer() );
		exit;
	}
	if( $qq == '' ) $qq=0;
	$db->query( "INSERT INTO `" . PREFIX_STR . "User` (`UserName`,`PassWord`,`Group`,`IsDel`,`Email`,`QQnum`,`Index`,`Time`,`IP`) VALUES ('$user_name','" . strtoupper( md5( PREFIX_STR . $pass_word ) ) . "',1,0,'$email',$qq,'$index','" . PHP_TIME . "','" . get_ip() . "')" );
	user_login( $user_name, $pass_word );
	show_message('注册成功，接下来将以注册用户身份登录', 'index.php');
	exit;
}

function logout() {
	$blog_path = str_replace( ' ','%20', BLOG_PATH );
	setcookie( PREFIX_STR . 'UserName', 'Guest', PHP_TIME + 31536000,$blog_path);
	setcookie( PREFIX_STR . 'PassWord', '0', PHP_TIME + 31536000,$blog_path);
	show_message( '你已经安全退出登录' , get_http_referer() );
	exit;
}

?>